<?php

namespace app\models\active;

use Yii;
use yii\db\ActiveRecord;
use yii\helpers\Html;

class Corp extends ActiveRecord
{
	
	public static function findCorp($id, $type = 1)
    {
        $corp = static::findOne($id);
		
		if(!isset($corp->id)) return 'Корпорация не найдена';
		
		$icon = '<img src="/images/foot/orden.png" width="18" style="vertical-align: middle;">';
		
		$corp->name = Yii::$app->user->identity->corp == $corp->id ? Html::tag('b',Html::encode($corp->name), ['style' => 'color: #0058a9;']) : Html::encode($corp->name);
		
		
		if($type == 1) return Html::a($icon.' '.$corp->name, ['corp/'.$id], ['class' => 'profile-link']);
		
	
		
		return Html::tag('span', $icon.' '.$corp->name, ['class' => 'profile-link']);
	
	}
	
	
	public static function CorpRatingPage()
	{
	    
	    $corp = static :: findOne(Yii::$app->user->identity->corp);
	    
	    if(!isset($corp->id)) return 0;
	    
	    $all = static :: find()->orderBy('cup desc')->all();
	    
	    $count = 1;
	    
	    foreach($all as $res):
	        
	        if($res['id'] == $corp->id) return $count;
	        
	        $count++;
	        
	   endforeach;
	   
	   
	    
	    
	}
	
	

    public static function Position($role)
    {
        
        $array = ['Стажер','Директор','Акционер','Заместитель','Владелец'];
        
        return $array[$role];
        
    }
	
	
	
	
	
}